//
//  BITimeEntriesWindow.h
//  BIViews
//
//  Created by Eric Hochmeister on 21/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCApplication/MCHelpController.h>
#import <MCApplication/MCTableView.h>

#import <BPSubstrate/BIDatabaseObjectContext.h>

@class MCTVToolbarView;
@class MCDurationPicker;
@class MCSimpleBox;
@class MCDurationFormatter;
@class BITextCheckTextView;

@interface BITimeEntriesWindow : NSWindowController

@property (nonatomic, assign) IBOutlet NSArrayController *timeEntriesController;
@property (nonatomic, assign) IBOutlet NSObjectController *slipController;
@property (nonatomic, assign) IBOutlet MCDurationFormatter *durationFormatter;

@property (nonatomic, assign) IBOutlet MCTVToolbarView *entriesTVToolbar;
@property (nonatomic, assign) IBOutlet MCTableView *entriesTableView;
@property (nonatomic, assign) IBOutlet NSTextField *durationLabelField;
@property (nonatomic, assign) IBOutlet MCSimpleBox *entryDetailsSimpleBox;
@property (nonatomic, assign) IBOutlet BITextCheckTextView *noteTextView;

@property (nonatomic, strong) BIDatabaseObjectContext *objectContext;
@property (nonatomic, strong) BITimeSlip *slip;
@property (nonatomic, assign, getter=isSlipBeingCreated) BOOL slipBeingCreated;
@property (nonatomic, assign, getter=isEditable) BOOL editable;

- (instancetype)initWithObjectContext:(BIDatabaseObjectContext*)objectContext;

- (IBAction)addTimeEntry:(id)sender;
- (IBAction)deleteTimeEntry:(id)sender;
- (BOOL)canAddTimeEntry;
- (BOOL)canDeleteTimeEntry;

- (IBAction)delete:(id)sender;

- (IBAction)endTimeEntriesWindow:(id)sender;

- (void)setupTimeEntriesTVToolbar;
- (void)setupForSlip:(id)aSlip isBeingCreated:(BOOL)aFlag;
- (void)setupForSlip:(id)aSlip isBeingCreated:(BOOL)aFlag isEditable:(BOOL)editable;

- (IBAction)help:(id)sender;

@end
